SET SQL_SAFE_UPDATES=0;

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='AD_POST_SCHOOL_STUDIES');

UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    psss.`id` AS ID,
    T5.`firstName` AS FIRST_NAME,
    T5.`middleName` AS MIDDLE_NAME,
    T5.`lastName` AS LAST_NAME,
    T5.`emailId` AS EMAIL_ID,
    T5.`mobileNumber` AS MOBILE_NO,
    T5.`mobileCountryCode` AS MOBILE_CODE,
    psss.remarks as REMARK,
    cds.itemValue as CERTIFICATE_STATUS,
    tds.itemValue as TRANSCRIPT_STATUS,
    dd.value as QUALIFICATION_TYPE
FROM
    post_school_studies_section psss
        LEFT JOIN
    applicant_person T5 ON T5.id = psss.applicant_person_id
        LEFT JOIN
    document_status cds ON cds.id = psss.certificate_doc_status
        LEFT JOIN
    document_status tds ON tds.id = psss.transcript_doc_status
        LEFT JOIN
    drop_down dd on dd.id = psss.qualificationType
WHERE
    psss.id IN (namedParams)",
    `jsonString` ='{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "remarks",
            "resultKey": "REMARK",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "itemValue",
            "resultKey": "CERTIFICATE_STATUS",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "itemValue",
            "resultKey": "TRANSCRIPT_STATUS",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "qualificationType",
            "resultKey": "QUALIFICATION_TYPE",
            "displayCode": "",
            "displayOrder": 7
        }
    ]}' WHERE (`dataProviderId` = @dtproviderId);

SET SQL_SAFE_UPDATES=1;